/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXPopup;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.transitions.CacheMemento;
import com.jfoenix.transitions.CachedTransition;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class JFXPopupSkin
implements Skin<JFXPopup> {
    protected JFXPopup control;
    protected StackPane container = new StackPane();
    protected Region popupContent;
    protected Node root;
    private Animation animation;
    protected Scale scale;

    public JFXPopupSkin(JFXPopup control) {
        this.control = control;
        this.scale = new Scale(1.0, 0.01, 0.0, 0.0);
        this.popupContent = control.getPopupContent();
        this.container.getStyleClass().add((Object)"jfx-popup-container");
        this.container.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.container.getChildren().add((Object)this.popupContent);
        this.container.getTransforms().add((Object)this.scale);
        this.container.setOpacity(0.0);
        this.root = JFXDepthManager.createMaterialNode((Node)this.container, 4);
        this.animation = this.getAnimation();
    }

    public void reset(JFXPopup.PopupVPosition vAlign, JFXPopup.PopupHPosition hAlign, double offsetX, double offsetY) {
        this.scale.setPivotX(hAlign == JFXPopup.PopupHPosition.RIGHT ? this.container.getWidth() : 0.0);
        this.scale.setPivotY(vAlign == JFXPopup.PopupVPosition.BOTTOM ? this.container.getHeight() : 0.0);
        this.root.setTranslateX(hAlign == JFXPopup.PopupHPosition.RIGHT ? -this.container.getWidth() + offsetX : offsetX);
        this.root.setTranslateY(vAlign == JFXPopup.PopupVPosition.BOTTOM ? -this.container.getHeight() + offsetY : offsetY);
    }

    public final void animate() {
        if (this.animation.getStatus() == Animation.Status.STOPPED) {
            this.animation.play();
        }
    }

    public JFXPopup getSkinnable() {
        return this.control;
    }

    public Node getNode() {
        return this.root;
    }

    public void dispose() {
        this.animation.stop();
        this.animation = null;
        this.container = null;
        this.control = null;
        this.popupContent = null;
        this.root = null;
    }

    protected Animation getAnimation() {
        return new PopupTransition();
    }

    public void init() {
        this.animation.stop();
        this.container.setOpacity(0.0);
        this.scale.setX(0.0);
        this.scale.setY(0.0);
    }

    private final class PopupTransition
    extends CachedTransition {
        PopupTransition() {
            super(JFXPopupSkin.this.root, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)JFXPopupSkin.this.popupContent.opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXPopupSkin.this.scale.xProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXPopupSkin.this.scale.yProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)700.0), new KeyValue[]{new KeyValue((WritableValue)JFXPopupSkin.this.scale.xProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXPopupSkin.this.popupContent.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)JFXPopupSkin.this.popupContent.opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXPopupSkin.this.scale.yProperty(), (Object)1, Interpolator.EASE_BOTH)})}), new CacheMemento((Node)JFXPopupSkin.this.popupContent));
            this.setCycleDuration(Duration.seconds((double)0.4));
            this.setDelay(Duration.seconds((double)0.0));
        }

        @Override
        protected void starting() {
            JFXPopupSkin.this.container.setOpacity(1.0);
            super.starting();
        }
    }
}

